<?php

namespace App\Modules\HR\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Employee extends Model 
{

    protected $table = 'employees';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('identification_number', 'first_name', 'second_name', 'third_name', 'last_name', 'phone', 'identity_date', 'date_of_birth', 'marital_status', 'email', 'gender', 'qualification', 'address', 'employee_job_information_id');

    public function nationality()
    {
        return $this->belongsTo('App\Modules\HR\Entities\Nationality');
    }

    public function attachments()
    {
        return $this->hasMany('App\Modules\HR\Entities\Attachment');
    }

    public function employeeJobInformation()
    {
        return $this->hasOne('App\Modules\HR\Entities\EmployeeJobInformation');
    }

    public function custodies()
    {
        return $this->hasMany('App\Modules\HR\Entities\Custody');
    }

    public function user()
    {
        return $this->hasOne('App\Models\User');
    }

    public function customer_service()
    {
        return $this->hasOne('App\Modules\CustomerService\Entities\CustomerService');
    }

    public function meetings()
    {
        return $this->belongsToMany('App\Modules\Secretariat\Entities\Meeting');
    }

    public function visits()
    {
        return $this->belongsToMany('App\Modules\Reception\Entities\Visit');
    }

}